<?php
require 'rest-api.php';

$response = [];

// Check if appointment ID is provided in GET request
$appointment = isset($_GET['appointment']) ? $_GET['appointment'] : null;
if ($appointment !== null && $appointment !== '') {
    $access_token = getAccessToken();
    if ($access_token) {
        $api = getAPI('get_op_feedback_form');
        $jsonData = json_encode(['appointment' => $appointment]);
        $response = curlForAPI('POST', $jsonData, $access_token, REST_API_ROOT_URL_FEEDBACK . $api);
        if ($response && isset($response['status']) && $response['status'] == 'already_submitted') {
            echo "<script type='text/javascript'>
            window.location.href = 'feedback-already-saved-alert.php';
          </script>";
        }
        if ($response && isset($response['status']) && $response['status'] == 'error') {
            echo "<script type='text/javascript'>
            window.location.href = '" . WEBSITE_URL . "';
            </script>";
        }
    } else {
        echo "<script type='text/javascript'>
        window.location.href = '" . WEBSITE_URL . "';
        </script>";
    }
} else {
    echo "<script type='text/javascript'>
    window.location.href = '" . WEBSITE_URL . "';
    </script>";
}

// Get patient details and feedback form from the response
$patientDetails = isset($response['patientDetails']) ? $response['patientDetails'] : [];
$feedbackForm = isset($response['feedbackForm']) ? $response['feedbackForm'] : [];
if (empty($patientDetails)) {
    echo "<script type='text/javascript'>
    window.location.href = '" . WEBSITE_URL . "';
    </script>";
}
if (empty($feedbackForm)) {
    echo "<script type='text/javascript'>
    window.location.href = '" . WEBSITE_URL . "';
    </script>";
}
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link href="assets/css/bootstrap.min.css" rel="stylesheet">
        <link href="assets/css/styles.css" rel="stylesheet">
        <link rel="icon" href="assets/images/logo-title.png" type="image/jpeg">
        <script src="assets/js/jquery-3.6.0.min.js"></script>
        <title>Patient Feedback Form</title>
    </head>
    <body>
        <!-- Spinner div - Initially hidden -->
        <div class="spinner" style="display:none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%);">
            <div class="spinner-border" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
        <section class="naseem-feedback-mainsec p-3 container my-5">
            <div class="nasem-feedbk-div">
                <div class="mb-5 logo-header-div">
                    <img src="assets/images/logo.png" alt="">
                </div>
                <!-- header section -->
                <div class="feedback-header-sec">
                    <span class="doc-fedbk-span">Doctor Consultation Feedback</span>
                    <h2>We Value Your Feedback!</h2>
                    <h6>Help us improve by sharing your thoughts.</h6>
                </div>
                <!-- patient details seciton -->
                <div class="feedback-patient-dtl p-3 mt-3">
                    <div class="feedback-patient-subdtl">
                        <div class="d-flex align-items-center"><i class="fa fa-user me-2"></i>
                            <p>Patient Name: <b><?= isset($patientDetails['patientName']) ? htmlspecialchars($patientDetails['patientName']) : 'N/A' ?></b></p>
                        </div>
                        <div class="d-flex align-items-center"><i class="fa fa-ticket me-2"></i>
                            <p>Token: <b><?= isset($patientDetails['appointmentToken']) ? htmlspecialchars($patientDetails['appointmentToken']) : 'N/A' ?></b></p>
                        </div>
                        <div class="d-flex align-items-center"><i class="fa fa-stethoscope me-2"></i>
                            <p>Doctor Name: <b><?= isset($patientDetails['doctorName']) ? htmlspecialchars($patientDetails['doctorName']) : 'N/A' ?></b></p>
                        </div>
                        <div class="d-flex align-items-center"><i class="fa fa-calendar me-2"></i>
                            <p>Consultation Date: <b><?= isset($patientDetails['appointmentDate']) ? htmlspecialchars($patientDetails['appointmentDate']) : 'N/A' ?></b></p>
                        </div>
                    </div>
                </div>

                <?php
                // Decode the JSON response to an associative array
                $jsonFeedbackForm = json_encode($feedbackForm);
                $data = json_decode($jsonFeedbackForm, true);
                if (!empty($data)) {

                    // Feedback Form Section
                    echo '<h2 class="mt-4">Feedback Form</h2>';
                    echo '<input type="hidden" id="appointment_id" value="' . $appointment . '"/>';
                    echo '<form id="feedbackForm" method="POST" action="">';

                    // Loop through the questions and render them dynamically
                    $count = 0;
                    foreach ($data['data'] as $questionData) {
                        $count++;
                        // Check if there are options to display (for radio buttons or select dropdown)
                        if (!empty($questionData['options'])) {
                            if ($questionData['isRating']) {
                                echo '<div class="fedbk-choice-dtl p-3 mt-3">
                            <div class="fedbk-choice-subdtl">
                                <div class="fedbk-choice-sub">
                                    <p><b>' . $count . ') ' . htmlspecialchars($questionData['question']) . '</b></p>
                                </div>
                                <div class="d-flex justify-content-center">
                                    <div class="feedbk-rating">';
                                foreach (array_reverse($questionData['options']) as $option) {
                                    echo '<input type="radio" id="' . htmlspecialchars($questionData['param']) . htmlspecialchars($option['name']) . '" name="' . htmlspecialchars($questionData['param']) . '" value="' . htmlspecialchars($option['name']) . '" />
                                        <label for="' . htmlspecialchars($questionData['param']) . htmlspecialchars($option['name']) . '" title="' . htmlspecialchars($option['name']) . '">' . htmlspecialchars($option['name']) . '</label>';
                                }
                                echo '</div>
                                </div>
                            </div>
                        </div>';
                            } else {
                                echo '<div class="fedbk-choice-dtl p-3 mt-3">
                                    <div class="fedbk-choice-subdtl">
                                        <div class="fedbk-choice-sub">
                                            <p><b>' . $count . ') ' . htmlspecialchars($questionData['question']) . '</b></p>
                                            <div>';
                                foreach ($questionData['options'] as $option) {
                                    echo '<div class="radio border-bottom py-3 d-flex">
                                            <input class="cursor-pointer" type="radio" id="' . htmlspecialchars($questionData['param']) . htmlspecialchars($option['name']) . '" name="' . htmlspecialchars($questionData['param']) . '" value="' . htmlspecialchars($option['name']) . '" />  '
                                    . '<label class="ps-2 cursor-pointer" for="' . htmlspecialchars($questionData['param']) . htmlspecialchars($option['name']) . '" >' . htmlspecialchars($option['name']) . '</label>
                                                </div>';
                                }
                                echo '</div>
                                        </div>
                                    </div>
                                </div>';
                            }
                        } else {
                            // For questions without options, render a simple text field
                            echo '<div class="fedbk-choice-dtl p-3 mt-3">
                                <div class="adtnl-conmnt-subdtl">
                                    <div>
                                        <p><b>' . $count . ') ' . htmlspecialchars($questionData['question']) . '</b></p>
                                        <div>
                                            <textArea class="w-100 textArea-field-border-style" name="' . htmlspecialchars($questionData['param']) . '" id="' . htmlspecialchars($questionData['param']) . '"
                                                ></textArea>
                                        </div>
                                    </div>
                                </div>
                            </div>';
                        }
                    }

                    echo '<div class="row mt-3">
                    <div class="col-md-12 text-center" id="formErrorMessage" style="color: red; display: none;"></div>
                        <div class="col-md-12 text-center">
                            <button class="submit-fed-btn" type="submit" class="btn btn-primary">Submit Feedback</button>
                        </div>
                    </div>';

                    echo '</form>';
                } else {
                    echo "<div class='alert alert-warning'>Unable to load feedback form.</div></div></section>";
                }
                ?>
                <script>
                    $(document).ready(function () {
                        $('#feedbackForm').on('submit', function (e) {
                            e.preventDefault();

                            var appointment_id = $('#appointment_id').val();
                            var formData = $(this).serializeArray();
                            var dataToSend = {
                                appointment_id: appointment_id,
                                form_data: {}
                            };

                            formData.forEach(function (item) {
                                if (item.value.trim() != '') {
                                    dataToSend.form_data[item.name] = item.value;
                                }
                            });
                            $('#formErrorMessage').hide();
                            if (Object.keys(dataToSend.form_data).length <= 0) {
                                $('#formErrorMessage').text('Please enter any of the fields to submit feedback').show();
                                return false;
                            }
                            $('.spinner').show();
                            $('#submit-fed-btn').attr('disabled', true);
                            $.ajax({
                                url: 'save-op-feedback-form.php',
                                type: 'POST',
                                data: {data: JSON.stringify(dataToSend)},
                                dataType: 'json',
                                success: function (response) {
                                    if (response.status == 'success') {
                                        window.location.href = 'success-page.php';
                                    } else if (response.status == 'already_submitted') {
                                        window.location.href = 'feedback-already-saved-alert.php';
                                    } else {
                                        $('#formErrorMessage').text('Please enter any of the fields to submit feedback').show();
                                        $('#submit-fed-btn').attr('disabled', false);
                                    }
                                },
                                error: function () {
                                    $('#formErrorMessage').text('Please enter any of the fields to submit feedback').show();
                                    $('#submit-fed-btn').attr('disabled', true);
                                },
                                complete: function () {
                                    $('.spinner').hide();
                                }
                            });
                        });

                        $(".textArea-field-border-style").on("keyup", function () {
                            $(this).css("height", "63px");
                            let scHeight = this.scrollHeight;
                            $(this).css("height", scHeight + "px");
                        });

                    });

                </script>
                </body>
                </html>
