<?php

require 'rest-api.php';

$response = [
    'success' => false,
    'message' => 'Something went wrong!'
];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
 
    // Get the JSON string from the POST request
    $jsonData = $_POST['data']; 
    
    // Now decode the JSON data directly
    $formData = json_decode($jsonData, true);

    if (empty($formData)) {
        $response['message'] = 'No form data received';
        echo json_encode($response);
        exit;
    }
    $appointment_id = $formData['appointment_id'];
    $labTestDetail_id = $formData['labTestDetail_id'];
    $form_data = $formData['form_data'];

    $access_token = getAccessToken();
    if ($access_token) {

        $dataToSend = [
            'appointment_id' => $appointment_id,
            'labTestDetail_id' => $labTestDetail_id,
            'form_data' => $form_data
        ];

        // Call the API to save the feedback
        $api = getAPI('save_op_feedback_form');
        $jsonData = json_encode(['data' => $dataToSend]);
        
        $apiResponse = curlForAPI('POST', $jsonData, $access_token, REST_API_ROOT_URL_FEEDBACK . $api);
        $response['status'] = 'error';
        $response['success'] = 'false';
        if ($apiResponse && isset($apiResponse['status']) && $apiResponse['status'] == 'success') {
            $response['success'] = 'true';
            $response['status'] = 'success';
            $response['message'] = 'Feedback submitted successfully!';
        } else if ($apiResponse && isset($apiResponse['status']) && $apiResponse['status'] == 'already_submitted') {
            $response['status'] = 'already_submitted';
            $response['message'] = '';
        } else {
            $response['message'] = 'Failed to save feedback. Please try again later.';
        }
    } else {
        $response['message'] = 'Failed to authenticate. Please try again later.';
    }
} else {
    $response['message'] = 'Invalid request method';
}

// Return the response as JSON
echo json_encode($response);
?>
